Include([[Data/levels/include/level_utils.lua]])

local currentTimer
Level =
{
	MapSkinFilename = [[jungle.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission2.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.5,
		BPGainMultiplier 	= 1.5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
		DefaultHiveTowerCount = 8,
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
		DisableLockdown = true,         --Turn off emergency help is player is behind
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)

        currentTimer:ResetTimer(5000)

	end
}


------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		

        local lab = GameWorld:GetEntityById("researchLab")
        GameWorld:CreateGroundDecal("DynamicInfestDecalLarge", lab)
		GameWorld:RegisterRaidTarget(lab)
		
		LevelUtils.ShowTimedDialogue("Brace yer behinds team!\n\nThe grubs are comin at us fast and strong", "Sarge")
        SwitchToNightMode()

        LossCondition:Enable()
        CaptureAllGoal:Enable()

		self:Disable()
	end)
LevelInit:Enable()

local nightModeOn = false
local dayExtension = 0
local dayCount = 0
local nightLossAllowance = 0
function SwitchToDayMode()

    nightModeOn = false

    GameWorld:SetSpawnRate(0.0)
    GameWorld:SetSpawnRateScalingOn(false)

    GameWorld:DeactivateMutation("ZU_BONE_SHIELD", false)
    GameWorld:DeactivateMutation("ZU_TOWER_CARAPACE", false)
    GameWorld:DeactivateMutation("ZU_HIVE_SPIKES", false)
    GameWorld:DeactivateMutation("ZU_WALK_SPEED", false)
    GameWorld:DeactivateMutation("ZU_SPAWNER_SPECIAL", false)
    GameWorld:DeactivateMutation("ZU_NECRONODE", false)

    GameWorld:SetRule("NoPushback", true)
    GameWorld:SetRule("NoTowerRespawn", true)

    local dayLength = 2*60*1000 + dayExtension*45*1000 + CaptureAndLossTracker:GetPointsBehind()*50*1000
    currentTimer = LevelUtils.CreateTimer(dayLength, "KILL THE ALIENS - %s", function() SwitchToNightMode() end)
    ScriptMgr:DoDelayedCall(dayLength-10000, function () GameWorld:MakeAnnouncement("Incoming\nAttack"); end)

    local entCount = GameWorld:GetEntityCount()
    for i=0,entCount-1 do
        local ent = GameWorld:GetEntityByIndex(i)
        
        if ent then
            if ent:ToCBulwark() or ent:ToCNecronode() then
                ent:Kill()
            end
        end
    end

    GameWorld:MakeAnnouncement("KILL THE ALIENS")
    
    dayCount = dayCount + 1
    if dayCount == 1 then       LevelUtils.ShowTimedDialogue("Heh, the little bastards are fallin back\n\nLets go raise some hell on their turf!", "Sarge")
    elseif dayCount == 2 then   LevelUtils.ShowTimedDialogue("Drake, the aliens are weak again\n\nNow is your chance to strike back!", "Scout")
    elseif dayCount == 3 then   LevelUtils.ShowTimedDialogue("Man, this is taking longer than I thought\n\nLet's go out there once more and show em", "Sarge")
    elseif dayCount == 4 then   LevelUtils.ShowTimedDialogue("You are doing a good job, Drake\n\nThey are retreating again - attack!", "General")
    elseif dayCount == 5 then   LevelUtils.ShowTimedDialogue("I wish we were gettin overtime pay for this\n\nI wonder if command will lend us a hand", "Sarge")
    else                        LevelUtils.ShowTimedDialogue("Let us finish them off\n\nJust a little bit more commander", "Scout")
    end
end

function SwitchToNightMode()

    nightModeOn = true
    nightLossAllowance = 2

    GameWorld:SetSpawnRate(20.0 + 3.5*CaptureRecordScript.capture_counter)
    GameWorld:SetSpawnRateScalingOn(false)
    
    GameWorld:ActivateMutation("ZU_BONE_SHIELD", false)
    GameWorld:ActivateMutation("ZU_HIVE_SPIKES", false)
    GameWorld:ActivateMutation("ZU_WALK_SPEED", false)
    
    if CaptureRecordScript.capture_counter >= 3 then
        GameWorld:ActivateMutation("ZU_SPAWNER_SPECIAL", false)
    end

    if CaptureRecordScript.capture_counter >= 5 then
        GameWorld:ActivateMutation("ZU_NECRONODE", false)
    end

    if CaptureRecordScript.capture_counter >= 7 then
        GameWorld:ActivateMutation("ZU_TOWER_CARAPACE", false)
    end
    
    GameWorld:SetRule("NoPushback", false)
    GameWorld:SetRule("NoTowerRespawn", false)
   
    GameWorld:RelayEvent([[NT_ALIEN_BESERK_SIGNAL]], "", vect2f(), "")
    ScriptMgr:DoDelayedCall(50000, 	function ()
                                        if nightModeOn then
                                            GameWorld:RelayEvent([[NT_ALIEN_BESERK_SIGNAL]], "", vect2f(), "")
                                        end
                                        return nightModeOn
                                    end)
                                    
    local dawnLength = 20*1000
    local nightExtension = math.min(CaptureRecordScript.capture_counter, 4) * 20*1000
    local nightLength = 40*1000 + dawnLength + nightExtension
    
    if CaptureRecordScript.captures_this_day == 0 then
        dawnLength = 10*1000
        nightLength = dawnLength + 30*1000
    end
    
    ScriptMgr:DoDelayedCall(nightLength - dawnLength, function () GameWorld:SetSpawnRate(0.0) end)               
    currentTimer = LevelUtils.CreateTimer(nightLength, "Survive - %s", function() SwitchToDayMode() end)
    
    dayExtension = dayExtension + 1
    CaptureRecordScript.captures_this_day = 0
end



------------------------------------------------------------------------------- Protohive (necronode) spawn type override
ProtohiveScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ALIEN_STRUCTURE_SPAWNED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        if p_other ~= "CNecronode" then
            return
        end
        
        local ent = GameWorld:GetEntityById(p_entId)
        if ent then
            local necNode = ent:ToCNecronode()
            
            if necNode then
                necNode:SetSpawnType(PHSpawnType.ST_ZOMBIE)
            end
        end
	end)
ProtohiveScript:Enable()

------------------------------------------------------------------------------- Capture Record Tracker
CaptureRecordScript = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
		self.captures_this_day = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        self.capture_counter = self.capture_counter + 1
        self.captures_this_day = self.captures_this_day + 1
        dayExtension = dayExtension - 0.5
        if dayExtension < 0 then
            dayExtension = 0
        end
	end)
CaptureRecordScript:Enable()


------------------------------------------------------------------------------- Capture and Loss Tracker
CaptureAndLossTracker = LevelUtils.MakeGoal(
	function (self)
		self.current_score = 0
		self.top_score = 0
		self.point_ever_lost = false
	end,
	
	{[[NT_POINT_CAPTURED]], [[NT_POINT_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        if p_type == [[NT_POINT_CAPTURED]] then
            self.current_score = self.current_score + 1
        end
        
        if p_type == [[NT_POINT_LOST]] then
            self.current_score = self.current_score - 1
            self.point_ever_lost = true
        end
        
        if self.current_score > self.top_score then
            self.top_score = self.current_score
        end
        
        if p_type == [[NT_POINT_LOST]] then
            nightLossAllowance = nightLossAllowance - 1
            if nightModeOn and nightLossAllowance <= 0 then
                if currentTimer then
                    currentTimer:Disable()
                end
                
                SwitchToDayMode()
            end
        end
	end)
	
function CaptureAndLossTracker.GetPointsBehind(self)
    return self.top_score - self.current_score
end

CaptureAndLossTracker:Enable()

-- Do a single airstrike
function DoAirstrike(p_strikePos)
    local dir = vect2f(1.0, 0.0)
    dir:Rotate(GetRandomRange(0.0, math.pi*2))
   
    local chopper = GameWorld:SpawnChopper(dir, p_strikePos)    
    chopper:SetMission(ChopperOrder.CO_AIRSTRIKE_MISSILE, p_strikePos, "")
end

------------------------------------------------------------------------------- Loss Condition 
LossCondition = LevelUtils.MakeGoal(
	function (self)
	    GameWorld:AddObjective("labObj", "Protect the lab building")
                             
        local lab = GameWorld:GetEntityById("researchLab")
        local labHandle = lab:GetHandle()
        LevelUtils.CreateEntityHPMonitor(labHandle, {0.75, 0.55, 0.25, 0.1},
            function (p_hpFract)
                local text_hdl = nil
                if p_hpFract == 0.75 then
                    text_hdl = GameWorld:ShowText("Drake, the lab is under attack!\n\nWe need help over here.", "Scout")	
                elseif p_hpFract == 0.55 then
                    text_hdl = GameWorld:ShowText("Commander, the lab is very damaged.\n\nWe will not hold out much longer!", "Scout")	
                elseif p_hpFract == 0.25 then
                    text_hdl = GameWorld:ShowText("Damn you Drake, the lab is almost destroyed!\n\nGet off your ass and send some men up there!", "General")
                elseif p_hpFract == 0.1 then
                    text_hdl = GameWorld:ShowText("Lab bulkheads are collapsing.\n\nI don't think that we'll make it...", "Scout")
                end
                
                GameWorld:CreateTrainingArrow("researchLab")
                if text_hdl then
                    ScriptMgr:DoDelayedCall(7000,
                        function ()
                            text_hdl:ClearText()
                            GameWorld:RemoveTrainingArrow("researchLab")
                        end) 
                end
                
                local ent = labHandle:GetPtr()
                if ent then
                    ent:ApplyInvulnerability(20000)
                    
                    DoAirstrike(ent:GetPos())
                end
            end,
            true)                       
    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "researchLab" then
            return
        end

        GameWorld:ChangeObjectiveStatus("labObj", [[failed]])

        local text_hdl = GameWorld:ShowText("We have lost the lab!\n\nAll of the research has been destroyed.\nThere is no reason to stay here.", "Scout")
		ScriptMgr:DoDelayedCall(8000,
            function()
                GameWorld:GameOver(false)
                GameWorld:ClearText()
            end)
            
        CaptureAllGoal:Disable()
        
		if currentTimer then
		    currentTimer:Disable()
		end
		
		self:Disable()	
	end,
	
	function (self)
	end)


------------------------------------------------------------------------------- Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	function (self)
	    GameWorld:AddObjective("winObj", "Capture all nodes")
                                                   
    end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
		LossCondition:Disable()
		
		if currentTimer then
		    currentTimer:Disable()
		end
		
		self:Disable()
	end) 
		
------------------------------------------------------------------------------- Extra Win Achievement
LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_GAME_OVER]]},
	function (self, p_type, p_entId, p_pos, p_other)
        if p_other == "win" then
            if not CaptureAndLossTracker.point_ever_lost then
		        SteamAchievements:SetAchievement("BEAT_NIGHT_AND_DAY_EXTRA_NOLOSS")
		    end
		    
		    if GameWorld:GetStat([[ST_GAMETIME]]) <= 11*60*1000 then
		        SteamAchievements:SetAchievement("BEAT_NIGHT_AND_DAY_EXTRA_TIME")
		    end
		    
		end	
	end):Enable()
	